VERSION 5.00
Begin VB.Form fCairoDemo 
   Caption         =   "Cairo-Tutorial"
   ClientHeight    =   6495
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   8685
   LinkTopic       =   "Form1"
   ScaleHeight     =   6495
   ScaleWidth      =   8685
   StartUpPosition =   3  'Windows-Standard
   Begin VB.CheckBox chkSinglePoint 
      BackColor       =   &H00FFFFFF&
      Caption         =   "Single tangential Point Mode"
      Height          =   315
      Left            =   330
      TabIndex        =   1
      Top             =   150
      Width           =   2595
   End
   Begin CairoTutorial.ucCanvas ucCanvas1 
      Height          =   3945
      Left            =   0
      TabIndex        =   0
      Top             =   0
      Width           =   8175
      _ExtentX        =   14473
      _ExtentY        =   7646
   End
End
Attribute VB_Name = "fCairoDemo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private PStart As cControlPoint, PEnd As cControlPoint
Private P1 As cControlPoint, P2 As cControlPoint

Private Sub Form_Load()
  Caption = "Drag the Control-Points"
  Me.ScaleMode = vbPixels
  Set PStart = ucCanvas1.ControlPoints.Add("PStart", 100, 200)
  Set P1 = ucCanvas1.ControlPoints.Add("P1", 250, 50, vbGreen)
  Set P2 = ucCanvas1.ControlPoints.Add("P2", 300, 350, vbGreen)
  Set PEnd = ucCanvas1.ControlPoints.Add("PEnd", 450, 200)
End Sub

Private Sub Form_Resize()
  If ScaleHeight - ucCanvas1.Top > 0 Then ucCanvas1.Move 0, ucCanvas1.Top, ScaleWidth, ScaleHeight - ucCanvas1.Top
End Sub

Private Sub chkSinglePoint_Click()
  Draw ucCanvas1.CC
End Sub

Private Sub ucCanvas1_RefreshContents(CC As dhCairo.cCairoContext)
  Draw CC
End Sub

Private Sub Draw(CC As cCairoContext)
  'the following two lines ensure a complete Surface-Fill
  CC.SetSourceColor vbWhite
  CC.Paint
  
  CC.Save
    CC.TranslateDrawings 0.5, 0.5
    
    CC.SetLineCap CAIRO_LINE_CAP_ROUND
    
    If chkSinglePoint.Value = False Then 'draw the "full-Bezier" (with two different Tangential-points)
    
      'just in case it was switched to InVisible in the other mode below
      P2.Visible = True
      
      'this is the Bezier-Curve-Drawing (with a thick, red Pen)
      CC.MoveTo PStart.X, PStart.Y 'the Start-point of the Bezier is ensured with a simple MoveTo
      CC.CurveTo P1.X, P1.Y, P2.X, P2.Y, PEnd.X, PEnd.Y '<-PEnd is the "Curve-To-EndPoint" of the Bezier
        CC.SetSourceColor vbRed
        CC.SetLineWidth 4
      CC.Stroke
      
      'here we draw just two thin black lines between the relevant Control-points and their "anchor-points"
      'on the bezier ... this is just for better understanding of the beziers "tangential-relations"
      'simply comment out the block below, if this "disturbs" you
      CC.DrawLine P1.X, P1.Y, PStart.X, PStart.Y 'the P1-Point of the bezier is "connected to PStart"...
      CC.DrawLine P2.X, P2.Y, PEnd.X, PEnd.Y '...and the P2-Point-Param of the bezier is "connected to PEnd"
        CC.SetSourceColor vbBlack, 0.5
        CC.SetLineWidth 1
      CC.Stroke
      
    Else 'draw the "reduced Bezier", depending only on one single "tangential Point"

      P2.Visible = False 'not needed in this mode
      
      'this is the Bezier-Curve-Drawing (with a thick, red Pen)
      '!!!! note, that the difference to the above section (with two tangetial Points) does not use a CC.MoveTo
      CC.CurveTo PStart.X, PStart.Y, P1.X, P1.Y, PEnd.X, PEnd.Y '<-PEnd is the "Curve-To-EndPoint" of the Bezier
        CC.SetSourceColor vbRed
        CC.SetLineWidth 4
      CC.Stroke
      
      'here we draw just two thin black lines between the single Control-point and the "anchor-points"
      'on the bezier ... this is just for better understanding of the beziers "tangential-relations"
      'simply comment out the block below, if this "disturbs" you
      CC.DrawLine P1.X, P1.Y, PStart.X, PStart.Y 'the P1-Point of the bezier is "connected to PStart"...
      CC.DrawLine P1.X, P1.Y, PEnd.X, PEnd.Y '...and the P2-Point-Param of the bezier is "connected to PEnd"
        CC.SetSourceColor vbBlack, 0.5
        CC.SetLineWidth 1
      CC.Stroke
      
    End If
  CC.Restore
  
  ucCanvas1.Refresh '<- drawing of the current Control-points is "hidden" within this Refresh-method of the canvas
End Sub
